using System;

class Program
{
    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int K = int.Parse(input[1]);

        double[][] trkaci = new double[N][];
        for (int i = 0; i < N; i++)
        {
            string[] trkacInfo = Console.ReadLine().Split();
            trkaci[i] = new double[] { double.Parse(trkacInfo[0]), double.Parse(trkacInfo[1]) };
        }

        double low = 0;
        double high = 1e9; // 10^9
        double answer = -1;

        while (high - low > 1e-9)
        {
            double mid = (low + high) / 2;

            if (possible(trkaci, mid, K))
            {
                answer = mid;
                high = mid;
            }
            else
            {
                low = mid;
            }
        }

        Console.WriteLine($"{answer:F9}");
    }

    static bool possible(double[][] trkaci, double vreme, int K)
    {
        int count = 0;

        for (int i = 0; i < trkaci.Length; i++)
        {
            double finalPos = trkaci[i][0] + vreme * trkaci[i][1];
            for (int j = i + 1; j < trkaci.Length; j++)
            {
                double finalPosNext = trkaci[j][0] + vreme * trkaci[j][1];
                if (finalPos < finalPosNext)
                    count++;
            }
        }

        return count >= K;
    }
}